/*
 * This File is one of the examples from Java Application Development
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */

package applicationIO;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class FileOutput implements Output {
    StringBuilder buffer = new StringBuilder();
    private String fileName;
 
    //Constructor that requires the name of a file to set as our destination

    public FileOutput(String fileName) {
        this.fileName = fileName;
    }
    
    public void write(String input){
        buffer.append(input);
    };
    public void writeln(String input){
        buffer.append(input);
        buffer.append('\n');
    };
    
    public void close(){
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(fileName));
            out.write(buffer.toString());
            out.close();
        } catch (IOException ex) {
            Logger.getLogger(FileOutput.class.getName()).log(Level.SEVERE, null, ex);
        } 
//        System.out.println(buffer);
        //Create a fresh buffer for next time
        StringBuilder buffer = new StringBuilder();
    }

    //Set the name of the file that will be our destination
    public String getFileName() {
        return fileName;
    }

    //Get the name of the file that is our current destination
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

}
